#include "SSH.h"

namespace Upp {

Exec& Exec::StartExecute(const String& cmdline, Stream& out, Stream& err)
{
	StartExec(cmdline);
	StartRead(out, chunk_size);
	StartReadStdErr(err);
	StartGetExitCode();
	StartGetExitSignal();
	StartStop();
	return *this;
}

int Exec::Execute(const String& cmdline, Stream& out, Stream& err)
{
	StartExecute(cmdline, out, err);
	return JobQueue::Execute() ? code : GetError();
}
}